﻿using System;
using Microsoft.EntityFrameworkCore.Migrations;
using Npgsql.EntityFrameworkCore.PostgreSQL.Metadata;

namespace FarmatikoData.Migrations
{
    public partial class Initialmigration : Migration
    {
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.CreateTable(
                name: "HealthFacilities",
                columns: table => new
                {
                    Id = table.Column<int>(nullable: false)
                        .Annotation("Npgsql:ValueGenerationStrategy", NpgsqlValueGenerationStrategy.IdentityByDefaultColumn),
                    CreatedOn = table.Column<DateTime>(nullable: false, defaultValueSql: "now()"),
                    DeletedOn = table.Column<DateTime>(nullable: true),
                    Name = table.Column<string>(nullable: false),
                    Municipality = table.Column<string>(nullable: false),
                    Address = table.Column<string>(nullable: false),
                    Type = table.Column<string>(nullable: false),
                    Email = table.Column<string>(nullable: true),
                    Phone = table.Column<string>(nullable: true)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_HealthFacilities", x => x.Id);
                });

            migrationBuilder.CreateTable(
                name: "Pandemics",
                columns: table => new
                {
                    Id = table.Column<int>(nullable: false)
                        .Annotation("Npgsql:ValueGenerationStrategy", NpgsqlValueGenerationStrategy.IdentityByDefaultColumn),
                    CreatedOn = table.Column<DateTime>(nullable: false, defaultValueSql: "now()"),
                    DeletedOn = table.Column<DateTime>(nullable: true),
                    Name = table.Column<string>(nullable: true),
                    TotalMK = table.Column<int>(nullable: false),
                    ActiveMK = table.Column<int>(nullable: false),
                    DeathsMK = table.Column<int>(nullable: false),
                    NewMK = table.Column<int>(nullable: false),
                    TotalGlobal = table.Column<int>(nullable: false),
                    DeathsGlobal = table.Column<int>(nullable: false),
                    ActiveGlobal = table.Column<int>(nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_Pandemics", x => x.Id);
                });

            migrationBuilder.CreateTable(
                name: "HealthcareWorkers",
                columns: table => new
                {
                    Id = table.Column<int>(nullable: false)
                        .Annotation("Npgsql:ValueGenerationStrategy", NpgsqlValueGenerationStrategy.IdentityByDefaultColumn),
                    CreatedOn = table.Column<DateTime>(nullable: false, defaultValueSql: "now()"),
                    DeletedOn = table.Column<DateTime>(nullable: true),
                    Name = table.Column<string>(nullable: false),
                    Branch = table.Column<string>(nullable: false),
                    FacilityId = table.Column<int>(nullable: false),
                    Title = table.Column<string>(nullable: true)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_HealthcareWorkers", x => x.Id);
                    table.ForeignKey(
                        name: "FK_HealthcareWorkers_HealthFacilities_FacilityId",
                        column: x => x.FacilityId,
                        principalTable: "HealthFacilities",
                        principalColumn: "Id",
                        onDelete: ReferentialAction.Cascade);
                });

            migrationBuilder.CreateTable(
                name: "Medicines",
                columns: table => new
                {
                    Id = table.Column<int>(nullable: false)
                        .Annotation("Npgsql:ValueGenerationStrategy", NpgsqlValueGenerationStrategy.IdentityByDefaultColumn),
                    CreatedOn = table.Column<DateTime>(nullable: false, defaultValueSql: "now()"),
                    DeletedOn = table.Column<DateTime>(nullable: true),
                    Name = table.Column<string>(nullable: true),
                    Strength = table.Column<string>(nullable: true),
                    Form = table.Column<string>(nullable: true),
                    WayOfIssuing = table.Column<string>(nullable: true),
                    Manufacturer = table.Column<string>(nullable: true),
                    Price = table.Column<float>(nullable: false),
                    Packaging = table.Column<string>(nullable: true),
                    MedicineListId = table.Column<int>(nullable: true)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_Medicines", x => x.Id);
                });

            migrationBuilder.CreateTable(
                name: "PharmacyHeads",
                columns: table => new
                {
                    Id = table.Column<int>(nullable: false)
                        .Annotation("Npgsql:ValueGenerationStrategy", NpgsqlValueGenerationStrategy.IdentityByDefaultColumn),
                    CreatedOn = table.Column<DateTime>(nullable: false, defaultValueSql: "now()"),
                    DeletedOn = table.Column<DateTime>(nullable: true),
                    PharmacyMedicinesId = table.Column<int>(nullable: true),
                    PharmacyId = table.Column<int>(nullable: true),
                    Email = table.Column<string>(nullable: true),
                    Name = table.Column<string>(nullable: true),
                    Password = table.Column<string>(nullable: true)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_PharmacyHeads", x => x.Id);
                });

            migrationBuilder.CreateTable(
                name: "MedicineLists",
                columns: table => new
                {
                    Id = table.Column<int>(nullable: false)
                        .Annotation("Npgsql:ValueGenerationStrategy", NpgsqlValueGenerationStrategy.IdentityByDefaultColumn),
                    CreatedOn = table.Column<DateTime>(nullable: false, defaultValueSql: "now()"),
                    DeletedOn = table.Column<DateTime>(nullable: true),
                    MedicinesId = table.Column<int>(nullable: true),
                    HasMedicine = table.Column<bool>(nullable: false),
                    PharmacyHeadId = table.Column<int>(nullable: true)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_MedicineLists", x => x.Id);
                    table.ForeignKey(
                        name: "FK_MedicineLists_Medicines_MedicinesId",
                        column: x => x.MedicinesId,
                        principalTable: "Medicines",
                        principalColumn: "Id",
                        onDelete: ReferentialAction.Restrict);
                    table.ForeignKey(
                        name: "FK_MedicineLists_PharmacyHeads_PharmacyHeadId",
                        column: x => x.PharmacyHeadId,
                        principalTable: "PharmacyHeads",
                        principalColumn: "Id",
                        onDelete: ReferentialAction.Restrict);
                });

            migrationBuilder.CreateTable(
                name: "Pharmacies",
                columns: table => new
                {
                    Id = table.Column<int>(nullable: false)
                        .Annotation("Npgsql:ValueGenerationStrategy", NpgsqlValueGenerationStrategy.IdentityByDefaultColumn),
                    CreatedOn = table.Column<DateTime>(nullable: false, defaultValueSql: "now()"),
                    DeletedOn = table.Column<DateTime>(nullable: true),
                    Name = table.Column<string>(nullable: true),
                    Location = table.Column<string>(nullable: true),
                    Address = table.Column<string>(nullable: true),
                    WorkAllTime = table.Column<bool>(nullable: false),
                    PharmacyHeadId = table.Column<int>(nullable: true)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_Pharmacies", x => x.Id);
                    table.ForeignKey(
                        name: "FK_Pharmacies_PharmacyHeads_PharmacyHeadId",
                        column: x => x.PharmacyHeadId,
                        principalTable: "PharmacyHeads",
                        principalColumn: "Id",
                        onDelete: ReferentialAction.Restrict);
                });

            migrationBuilder.CreateIndex(
                name: "IX_HealthcareWorkers_FacilityId",
                table: "HealthcareWorkers",
                column: "FacilityId");

            migrationBuilder.CreateIndex(
                name: "IX_MedicineLists_MedicinesId",
                table: "MedicineLists",
                column: "MedicinesId");

            migrationBuilder.CreateIndex(
                name: "IX_MedicineLists_PharmacyHeadId",
                table: "MedicineLists",
                column: "PharmacyHeadId");

            migrationBuilder.CreateIndex(
                name: "IX_Medicines_MedicineListId",
                table: "Medicines",
                column: "MedicineListId");

            migrationBuilder.CreateIndex(
                name: "IX_Pharmacies_PharmacyHeadId",
                table: "Pharmacies",
                column: "PharmacyHeadId");

            migrationBuilder.CreateIndex(
                name: "IX_PharmacyHeads_PharmacyId",
                table: "PharmacyHeads",
                column: "PharmacyId");

            migrationBuilder.CreateIndex(
                name: "IX_PharmacyHeads_PharmacyMedicinesId",
                table: "PharmacyHeads",
                column: "PharmacyMedicinesId");

            migrationBuilder.AddForeignKey(
                name: "FK_Medicines_MedicineLists_MedicineListId",
                table: "Medicines",
                column: "MedicineListId",
                principalTable: "MedicineLists",
                principalColumn: "Id",
                onDelete: ReferentialAction.Restrict);

            migrationBuilder.AddForeignKey(
                name: "FK_PharmacyHeads_MedicineLists_PharmacyMedicinesId",
                table: "PharmacyHeads",
                column: "PharmacyMedicinesId",
                principalTable: "MedicineLists",
                principalColumn: "Id",
                onDelete: ReferentialAction.Restrict);

            migrationBuilder.AddForeignKey(
                name: "FK_PharmacyHeads_Pharmacies_PharmacyId",
                table: "PharmacyHeads",
                column: "PharmacyId",
                principalTable: "Pharmacies",
                principalColumn: "Id",
                onDelete: ReferentialAction.Restrict);
        }

        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropForeignKey(
                name: "FK_MedicineLists_Medicines_MedicinesId",
                table: "MedicineLists");

            migrationBuilder.DropForeignKey(
                name: "FK_MedicineLists_PharmacyHeads_PharmacyHeadId",
                table: "MedicineLists");

            migrationBuilder.DropForeignKey(
                name: "FK_Pharmacies_PharmacyHeads_PharmacyHeadId",
                table: "Pharmacies");

            migrationBuilder.DropTable(
                name: "HealthcareWorkers");

            migrationBuilder.DropTable(
                name: "Pandemics");

            migrationBuilder.DropTable(
                name: "HealthFacilities");

            migrationBuilder.DropTable(
                name: "Medicines");

            migrationBuilder.DropTable(
                name: "PharmacyHeads");

            migrationBuilder.DropTable(
                name: "Pharmacies");

            migrationBuilder.DropTable(
                name: "MedicineLists");
        }
    }
}
